/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.dao.vo;

import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.vo.AbstractCapabilityVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

public class StandardCapabilityVO
implements IPersistable,
Comparable {
    private boolean isNew = false;
    private boolean isDirty = false;
    private long lastUpdate = System.currentTimeMillis();
    private String standardID = null;
    private ArrayList stdElements = new ArrayList();

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew() {
        this.isNew = true;
    }

    public void setNew(boolean bl) {
        this.isNew = bl;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty() {
        this.isDirty = true;
    }

    public void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(long l) {
        this.lastUpdate = l;
    }

    public Object getId() {
        return this.standardID;
    }

    public String getStandardID() {
        return this.standardID;
    }

    public void setId(Object object) {
        this.standardID = (String)object;
    }

    public void setStandardID(String string) {
        this.standardID = string;
    }

    public Collection getCapabilities() throws Exception {
        LinkedHashMap<String, AbstractCapabilityVO> linkedHashMap = new LinkedHashMap<String, AbstractCapabilityVO>();
        for (StandardCapabilityElementVO standardCapabilityElementVO : this.stdElements) {
            linkedHashMap.put(standardCapabilityElementVO.getCapabilityId(), standardCapabilityElementVO.getCapability());
        }
        return linkedHashMap.values();
    }

    public List getStandardElements() {
        return Collections.unmodifiableList(this.stdElements);
    }

    public void setStandardElements(ArrayList arrayList) {
        this.stdElements = arrayList;
    }

    public void add(StandardCapabilityElementVO standardCapabilityElementVO) {
        this.stdElements.add(standardCapabilityElementVO);
    }

    public void add(StandardCapabilityElementVO standardCapabilityElementVO, int n) {
        this.stdElements.add(n, standardCapabilityElementVO);
    }

    public void remove(int n) {
        this.stdElements.remove(n);
    }

    public void removeAll() {
        this.stdElements.clear();
    }

    public int compareTo(Object object) throws ClassCastException {
        return this.standardID.compareTo(((StandardCapabilityVO)object).standardID);
    }

    public static StandardCapabilityElementVO create() {
        return new StandardCapabilityElementVO();
    }

    public static class StandardCapabilityElementVO
    implements Comparable {
        private String capabilityId = null;
        private String conformance = null;
        private String location = null;
        private String requirement = null;

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String string) {
            this.location = string;
        }

        public String getRequirement() {
            return this.requirement;
        }

        public void setRequirement(String string) {
            this.requirement = string;
        }

        public String getCapabilityId() {
            return this.capabilityId;
        }

        public void setCapabilityId(String string) {
            this.capabilityId = string;
        }

        public AbstractCapabilityVO getCapability() throws Exception {
            return (AbstractCapabilityVO)((Object)XMLDAOFactory.getCapabilityDAO().read(this.capabilityId));
        }

        public void setCapabilityVO(AbstractCapabilityVO abstractCapabilityVO) throws Exception {
            this.capabilityId = (String)abstractCapabilityVO.getId();
        }

        public String getConformance() {
            return this.conformance;
        }

        public void setConformance(String string) {
            this.conformance = string;
        }

        public int compareTo(Object object) throws ClassCastException {
            return this.capabilityId.compareTo(((StandardCapabilityElementVO)object).capabilityId);
        }
    }
}

